//this file is part of eMule
//Copyright (C)2002-2005 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "ResizableLib\ResizableDialog.h"
#include "SplitterControl.h"
#include "BtnST.h" //dlarge RollUps
#include "TabCtrl.hpp"
#include "UploadListCtrl.h"
#include "DownloadListCtrl.h"
#include "QueueListCtrl.h"
#include "ClientListCtrl.h"
#include "DownloadClientsCtrl.h"
#include "opcodes.h"
#include "share.h"
#include "ToolTips\PPToolTip.h" // [TPT] - MFCK [addon] - New Tooltips [Rayita]
#include "NextEMF\RollUpCtrl\RollupCtrl.h" //dlarge RollUps

// [TPT] - MFCK [addon] - New Tooltips [Rayita]
#define UPLOAD_WND		0
#define	QUEUE_WND		1
#define KNOWN_WND		2
#define TRANSF_WND		3
#define UPDOWN_WND		4
#define DOWNLOAD_WND	5
// [TPT] - MFCK [addon] - New Tooltips [Rayita]

class CDropDownButton;

//dlarge RollUps
class CUploadListCtrl;
class CDownloadListCtrl;
class CDownloadClientsCtrl;
class CQueueListCtrl;
class CClientListCtrl;
class CDummyForTabs;

enum EnumDownPanelWindows
{
	DPW_DOWNLOADLIST = 0,
	DPW_DOWNLOADCLIENTLIST,
	};

enum EnumMiddlePanelWindows
{
	MPW_UPLOADLIST = 0,
	MPW_UPLOADQUEUELIST,
	MPW_UPLOADCLIENTLIST,
	};

enum EnumExtPanelWindows
{
	EPW_LIST1 = 0,
	EPW_LIST2,
	};
//dlarge end

class CTransferWnd : public CResizableDialog
{
	DECLARE_DYNAMIC(CTransferWnd)

public:
	CTransferWnd(CWnd* pParent = NULL);   // standard constructor
	virtual ~CTransferWnd();

//dlarge RollUps
	void	SwitchUploadList();
	void	SwitchExtList();
	void	OnBnClickedQueueRefreshButton();
	void    Localize();
	void    UpdateCatTabTitles(bool force = true);
	bool	downloadlistactive;
	void	ShowQueueCount(uint32 number);

	void	InitRollupItemHeights();
	void	SaveRollupItemHeights();
	void	UpdateDownloadHeader();
	void	UpdateUploadHeader();
	void	UpdateExtendedHeader();	
//dlarge end

// [TPT] - MFCK [addon] - New Tooltips [Rayita]
	CImageList* GetImageList() { return &m_ImageList; }
	void DrawClientImage(CDC *dc, POINT &point, CUpDownClient* client);
	void SetTTDelay();
	void SetDlgItemFocus(int nID);
// [TPT] - MFCK [addon] - New Tooltips [Rayita]


	// Dialog Data
	enum { IDD = IDD_TRANSFER };
//dlarge RollUps
	EnumDownPanelWindows	m_nActiveDownWnd;
	EnumMiddlePanelWindows	m_nActiveUpWnd;
	EnumExtPanelWindows	m_nActiveExtWnd;
	
	CRollupCtrl		m_ctlRollup;
	CDummyForTabs		*m_pwndDummyForDownloadList;
	CDummyForTabs		*m_pwndDummyForDownloadList2;
//dlarge end
	
	CUploadListCtrl		uploadlistctrl;
	CDownloadListCtrl	downloadlistctrl;
	CQueueListCtrl		queuelistctrl;
	CClientListCtrl		clientlistctrl;
	CDownloadClientsCtrl	downloadclientsctrl;

protected:
	void DoSplitResize(int delta);
	CSplitterControl m_wndSplitter;
	CString GetCatTitle(int catid);

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);

	DECLARE_MESSAGE_MAP()

private:
	void		OnDblclickDltab();
	uint8		windowtransferstate;
	CButtonST	m_uplBtn;
	TabControl	m_dlTab;
	int		rightclickindex;
	void		EditCatTabLabel(int index,CString newlabel);
	void		EditCatTabLabel(int index);

// [TPT] - MFCK [addon] - New Tooltips [Rayita]		
	int		m_iOldToolTipItemDownload;
	int		m_iOldToolTipItemUpload;
	int		m_iOldToolTipItemQueue;
	int		m_iOldToolTipItemClients;
// [TPT] - MFCK [addon] - New Tooltips [Rayita]	

	bool		m_bFirstShow;	
	int		m_nDragIndex;
	int		m_nDropIndex;
	int		m_nLastCatTT;
	int		m_isetcatmenu;
	bool		m_bIsDragging;
	CImageList*     m_pDragImage;
	HICON		icon_download;
	POINT		m_pLastMousePoint;
//	CToolTipCtrlX*  m_tooltipCats; // [TPT] - MFCK [addon] - New Tooltips [Rayita]
	void	SetAllIcons();

// [TPT] - MFCK [addon] - New Tooltips [Rayita]
	int GetTabUnderMouse(CPoint* point);
        int GetItemUnderMouse(CListCtrl* ctrl); 
// [TPT] - MFCK [addon] - New Tooltips [Rayita]

	virtual BOOL PreTranslateMessage(MSG* pMsg);
	
public:
	afx_msg void OnHoverUploadList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnHoverDownloadList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTcnSelchangeDltab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRclickDltab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnBegindrag(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTabMovement(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	virtual BOOL OnCommand(WPARAM wParam,LPARAM lParam );
	int AddCategory(CString newtitle,CString newincoming,CString newcomment,CString newautocat,bool addTab=true);
	afx_msg void OnDestroy();
	afx_msg void OnLvnKeydownDownloadlist(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnSysColorChange();

	afx_msg BOOL OnEraseBkgnd(CDC* pDC); //dlarge RollUps

// [TPT] - MFCK [addon] - New Tooltips [Rayita]
	afx_msg BOOL OnToolTipNotify(UINT id, NMHDR *pNMH, LRESULT *pResult);
private:
	CMuleListCtrl*  lists_list[6];	
	CImageList      m_ImageList;
	CPPToolTip      m_ttip;
	CPPToolTip      m_tabtip;
	//CPPToolTip    m_othertips;
	CPPToolTip      m_btttp;

	void		UpdateTabToolTips() {UpdateTabToolTips(-1);}
	void		UpdateTabToolTips(int tab);
	void            UpdateToolTips();
	int             m_iOldToolTipItem[DOWNLOAD_WND];
	int             GetClientImage(CUpDownClient* client);
// [TPT] - MFCK [addon] - New Tooltips [Rayita]
};
